#include <bits/stdc++.h>
using namespace std;

struct Poncho { int w, v, idx; };

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    int N, W;
    double eps;
    cin >> N >> W >> eps;
    vector<Poncho> p(N);
    for(int i=0;i<N;i++){
        cin >> p[i].w >> p[i].v;
        p[i].idx = i+1;
    }

    vector<Poncho> small, large;
    for(auto &x:p){
        if(x.w <= W/2) small.push_back(x);
        else large.push_back(x);
    }

    sort(small.begin(), small.end(), [](Poncho &a, Poncho &b){
        return (double)a.v/a.w > (double)b.v/b.w;
    });

    vector<int> best_res;
    int best_val = 0;

    // Greedy samo male
    int tw=0, tv=0;
    vector<int> res;
    for(auto &x:small){
        if(tw + x.w <= W){
            tw += x.w;
            tv += x.v;
            res.push_back(x.idx);
        }
    }
    if(tv > best_val){
        best_val = tv;
        best_res = res;
    }

    // Probaj velike pojedinacno + mali greedy
    for(auto &L:large){
        if(L.w > W) continue;
        tw = L.w; tv = L.v;
        res = {L.idx};
        for(auto &x:small){
            if(tw + x.w <= W){
                tw += x.w;
                tv += x.v;
                res.push_back(x.idx);
            }
        }
        if(tv > best_val){
            best_val = tv;
            best_res = res;
        }
    }

    cout << best_res.size() << "\n";
    for(int i=0;i<best_res.size();i++) cout << best_res[i] << (i+1==best_res.size()?"\n":" ");
}